/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.client.screen.skill;

import dev.toma.gunsrpg.api.common.skill.ISkillHierarchy;
import dev.toma.gunsrpg.client.screen.skill.SkillViewData;
import dev.toma.gunsrpg.common.init.Skills;
import dev.toma.gunsrpg.common.skills.core.SkillCategory;
import dev.toma.gunsrpg.common.skills.core.SkillType;
import dev.toma.gunsrpg.util.ModUtils;
import dev.toma.gunsrpg.util.math.IDimensions;
import dev.toma.gunsrpg.util.math.IVec2i;
import dev.toma.gunsrpg.util.math.Vec2i;
import dev.toma.gunsrpg.util.math.Vec2iMutable;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class Tree
implements IDimensions {
    public static final int GRID_UNIT_SIZE = 4;
    public static final int HALF_UNIT = 2;
    private final SkillCategory category;
    private final Map<SkillType<?>, SkillViewData> dataViewMap = new IdentityHashMap();
    private final SkillType<?> root;
    private final int width;
    private final int height;
    private final boolean useSimplePlacement;
    private final List<Connector> connectorList = new ArrayList<Connector>();

    public Tree(SkillCategory category, SkillType<?> root) {
        this.category = category;
        this.root = root;
        this.useSimplePlacement = this.shouldUseSimplePlacement(root);
        this.fillPositionMap(root);
        this.width = this.calculateMaxWidth();
        this.height = this.calculateMaxHeight();
    }

    public void makeConnections(SkillType<?> head) {
        SkillType<?>[] children = head.getHierarchy().getChildren();
        if (children == null) {
            return;
        }
        for (SkillType<?> child : children) {
            this.connect(head, child);
            this.makeConnections(child);
        }
    }

    public SkillType<?> getRoot() {
        return this.root;
    }

    public void move(int xCorrection, int yCorrection) {
        this.dataViewMap.values().forEach(data -> data.move(xCorrection, yCorrection));
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public Set<Map.Entry<SkillType<?>, SkillViewData>> getDataSet() {
        return this.dataViewMap.entrySet();
    }

    public List<Connector> getConnectorList() {
        return this.connectorList;
    }

    private void fillPositionMap(SkillType<?> root) {
        TreeNode node = new TreeNode(root, 0, 0);
        this.generateViewDataForNode(node);
    }

    private void generateViewDataForNode(TreeNode node) {
        int childCount = node.childrenNodes != null ? node.childrenNodes.length : 0;
        boolean shouldCenter = !this.useSimplePlacement && childCount > 1;
        Vec2iMutable pos = new Vec2iMutable(node.xLevel * 4, node.yLevel * 4);
        if (shouldCenter) {
            int toCenter = (childCount - 1) * 2;
            pos.growX(toCenter);
            this.centerBranch(node, toCenter);
        }
        if (childCount > 0) {
            this.generateDefaultPositions(node);
        }
        this.dataViewMap.put(node.value, new SkillViewData(node.value, this.category, pos));
    }

    private void generateDefaultPositions(TreeNode node) {
        for (TreeNode node1 : node.childrenNodes) {
            this.generateViewDataForNode(node1);
        }
    }

    private void centerBranch(TreeNode node, int correction) {
        TreeNode parent;
        while ((parent = node.parent) != null) {
            TreeNode[] children = parent.childrenNodes;
            Optional.ofNullable(this.dataViewMap.get((Object)node.value)).ifPresent(data -> data.getPos().growX(correction));
            if (children != null && children.length > 1) break;
            node = parent;
        }
    }

    private int calculateMaxWidth() {
        return this.dataViewMap.values().stream().mapToInt(value -> value.getPos().x()).max().orElse(4);
    }

    private int calculateMaxHeight() {
        return this.dataViewMap.values().stream().mapToInt(value -> value.getPos().y()).max().orElse(4);
    }

    private boolean shouldUseSimplePlacement(SkillType<?> root) {
        return root == Skills.WOODEN_AMMO_SMITH;
    }

    private void connect(SkillType<?> parent, SkillType<?> child) {
        IVec2i pos1 = this.getPosition(parent);
        IVec2i pos2 = this.getPosition(child);
        if (pos1.x() == pos2.x()) {
            Connector connector = new Connector(pos1, pos2, child);
            this.connectorList.add(connector);
        } else {
            int diffY = pos2.y() - pos1.y();
            int halfY = pos1.y() + diffY / 2;
            Vec2i pos3 = new Vec2i(pos1.x(), halfY);
            Vec2i pos4 = new Vec2i(pos2.x(), halfY);
            this.connectorList.add(new Connector(pos1, pos3, child));
            this.connectorList.add(new Connector(pos3, pos4, child));
            this.connectorList.add(new Connector(pos4, pos2, child));
        }
    }

    private IVec2i getPosition(SkillType<?> type) {
        SkillViewData data = this.dataViewMap.get(type);
        return data.getPos();
    }

    public static final class Connector {
        private final IVec2i pos1;
        private final IVec2i pos2;
        private final SkillType<?> dest;

        private Connector(IVec2i pos1, IVec2i pos2, SkillType<?> dest) {
            this.pos1 = pos1;
            this.pos2 = pos2;
            this.dest = dest;
        }

        public IVec2i getStart() {
            return this.pos1;
        }

        public IVec2i getEnd() {
            return this.pos2;
        }

        public SkillType<?> getDestinationSkill() {
            return this.dest;
        }
    }

    private class TreeNode {
        private final int xLevel;
        private final int yLevel;
        private final SkillType<?> value;
        private final TreeNode parent;
        private final TreeNode[] childrenNodes;

        TreeNode(SkillType<?> value, int xLevel, int yLevel) {
            this(value, null, xLevel, yLevel);
        }

        TreeNode(SkillType<?> value, TreeNode parent, int xLevel, int yLevel) {
            this.value = value;
            this.parent = parent;
            this.xLevel = xLevel;
            this.yLevel = yLevel;
            this.childrenNodes = this.getChildrenNodes();
        }

        TreeNode[] getChildrenNodes() {
            TreeNode[] out;
            ISkillHierarchy<?> hierarchy = this.value.getHierarchy();
            SkillType<?>[] children = hierarchy.getChildren();
            if (ModUtils.isNullOrEmpty(children)) {
                return null;
            }
            if (Tree.this.useSimplePlacement && children.length == 2) {
                out = new TreeNode[2];
                SkillType<?> right = children[1];
                SkillType<?> below = children[0];
                out[0] = new TreeNode(right, this, this.xLevel + 1, this.yLevel);
                out[1] = new TreeNode(below, this, this.xLevel, this.yLevel + 1);
            } else {
                out = this.generateDefaultPlacement(children);
            }
            return out;
        }

        private TreeNode[] generateDefaultPlacement(SkillType<?>[] children) {
            TreeNode[] out = new TreeNode[children.length];
            for (int i = 0; i < children.length; ++i) {
                TreeNode childNode;
                SkillType<?> child = children[i];
                out[i] = childNode = new TreeNode(child, this, this.xLevel + i, this.yLevel + 1);
            }
            return out;
        }
    }
}

